
//****************************************************************************************************/
//* JQuery pour les modules Divi et les rendre accessibles dans le cadre de l'Accessibilte Numerique */
//* Site Web: https://la-va11ydette.orange.com/														 */							
//* Version:  1.0.0									   												 */
//* Author:   jeanmichel.pillon@orange.com 			   												 */
//****************************************************************************************************/

//********************************************************/
// ** Ajouter un attribut title aux liens du module Text */
//********************************************************/

jQuery(document).ready(function($) {
    $('.et_pb_text a').each(function() {
        var $this = $(this);
        var linkText = $this.text().trim();
        var href = $this.attr('href');
        var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
        var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

        if (isDocument) {
            // Mettre à jour le title pour les documents avec le format
            $this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
        } else if ($this.find('svg').length > 0) {
            $this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
        } else {
            $this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
        }
    });
});


/****************************************************/
/* Desactiver l'affichage du champ title de l'image */
/****************************************************/

jQuery(document).ready(function($) {
    $('img[title]').removeAttr('title');
});

//****************************/
// ** Module Post navigation */
//****************************/

jQuery(document).ready(function($) {
    $('.nav-previous a .nav-label').each(function() {
        var $this = $(this);
        var linkText = $this.text().trim();
        var href = $this.attr('href');
        $this.attr( 'title', "Page " + linkText.toLowerCase() + " dans le même onglet");
    });
});

jQuery(document).ready(function($) {
    $('.nav-next a .nav-label').each(function() {
        var $this = $(this);
        var linkText = $this.text().trim();
        var href = $this.attr('href');
        $this.attr( 'title', "Page " + linkText.toLowerCase() + " dans le même onglet");
    });
});


//*******************************/
// ** Module Accordio et Toggle */
//*******************************/

jQuery(document).ready(function($) {
	// Remplacer <h5> par <h3> dans le module Accordio et Toggle
	$('.et_pb_toggle h5').each(function() {
		var $this = $(this);
		var newHeading = $('<h3>').html($this.html()).attr('class', $this.attr('class')); // Conserver les classes
		$this.replaceWith(newHeading);
	});

	// Reactiver le comportement de Toggle
	$('.et_pb_toggle h3').on('click', function() {
		var $content = $(this).next('.et_pb_toggle_content');
		$content.slideToggle();
		$(this).closest('.et_pb_toggle').toggleClass('et_pb_toggle_active');
	});
});

// Ajouter un attribut title aux liens module Accordio
jQuery(document).ready(function($) {
	$('.et_pb_accordion .et_pb_toggle_content a').each(function() {
		var $this = $(this);
		var linkText = $this.text().trim();
		var href = $this.attr('href');
		var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
		var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

		if (isDocument) {
			// Mettre à jour le title pour les documents avec le format
			$this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
		} else if ($this.find('svg').length > 0) {
			$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
		} else {
			$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
		}
	});
});

// Ajouter un attribut title aux liens module Toogle
jQuery(document).ready(function($) {
	$('.et_pb_toggle .et_pb_toggle_content a').each(function() {
		var $this = $(this);
		var linkText = $this.text().trim();
		var href = $this.attr('href');
		var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
		var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

		if (isDocument) {
			// Mettre à jour le title pour les documents avec le format
			$this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
		} else if ($this.find('svg').length > 0) {
			$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
		} else {
			$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
		}
	});
});


//*****************/
// ** Module Tabs */
//*****************/

// Tabulation module Tabs */
jQuery(document).ready(function($) {
	// Rendre les onglets accessibles via la tabulation
	$('.et_pb_tab_0, .et_pb_tab_1, .et_pb_tab_2, .et_pb_tab_3, .et_pb_tab_4, .et_pb_tab_5, .et_pb_tab_6, .et_pb_tab_7, .et_pb_tab_8, .et_pb_tab_9, .et_pb_tab_10, .et_pb_tab_11, .et_pb_tab_12, .et_pb_tab_13, .et_pb_tab_14, .et_pb_tab_15, .et_pb_tab_16, .et_pb_tab_17, .et_pb_tab_18, .et_pb_tab_19, .et_pb_tab_20').attr('tabindex', '0'); // Rendre les onglets focusables

	// Gerer l'evenement de clic pour activer le contenu de l'onglet
	$('.et_pb_tab_0, .et_pb_tab_1, .et_pb_tab_2, .et_pb_tab_3, .et_pb_tab_4, .et_pb_tab_5, .et_pb_tab_6, .et_pb_tab_7, .et_pb_tab_8, .et_pb_tab_9, .et_pb_tab_10, .et_pb_tab_11, .et_pb_tab_12, .et_pb_tab_13, .et_pb_tab_14, .et_pb_tab_15, .et_pb_tab_16, .et_pb_tab_17, .et_pb_tab_18, .et_pb_tab_19, .et_pb_tab_20').on('click', function() {
		var tabId = $(this).data('tab'); // Recuperer l'ID de l'onglet
		$('.et_pb_tab_0, .et_pb_tab_1, .et_pb_tab_2, .et_pb_tab_3, .et_pb_tab_4, .et_pb_tab_5, .et_pb_tab_6, .et_pb_tab_7, .et_pb_tab_8, .et_pb_tab_9, .et_pb_tab_10, .et_pb_tab_11, .et_pb_tab_12, .et_pb_tab_13, .et_pb_tab_14, .et_pb_tab_15, .et_pb_tab_16, .et_pb_tab_17, .et_pb_tab_18, .et_pb_tab_19, .et_pb_tab_20').removeClass('active'); // Retirer la classe active de tous les onglets
		$(this).addClass('active'); // Ajouter la classe active à l'onglet clique
	});

// Gerer la navigation au clavier avec les flèches gauche et droite
$('.et_pb_tab_0, .et_pb_tab_1, .et_pb_tab_2, .et_pb_tab_3, .et_pb_tab_4, .et_pb_tab_5, .et_pb_tab_6, .et_pb_tab_7, .et_pb_tab_8, .et_pb_tab_9, .et_pb_tab_10, .et_pb_tab_11, .et_pb_tab_12, .et_pb_tab_13, .et_pb_tab_14, .et_pb_tab_15, .et_pb_tab_16, .et_pb_tab_17, .et_pb_tab_18, .et_pb_tab_19, .et_pb_tab_20').on('keydown', function(e) {
	var $tabs = $('.et_pb_tab_0, .et_pb_tab_1, .et_pb_tab_2, .et_pb_tab_3, .et_pb_tab_4, .et_pb_tab_5, .et_pb_tab_6, .et_pb_tab_7, .et_pb_tab_8, .et_pb_tab_9, .et_pb_tab_10, .et_pb_tab_11, .et_pb_tab_12, .et_pb_tab_13, .et_pb_tab_14, .et_pb_tab_15, .et_pb_tab_16, .et_pb_tab_17, .et_pb_tab_18, .et_pb_tab_19, .et_pb_tab_20');
	var index = $tabs.index(this);

	if (e.key === 'ArrowRight') { // Flèche droite
		index = (index + 1) % $tabs.length; // Passer à l'onglet suivant
		$tabs.eq(index).focus().click(); // Mettre le focus sur l'onglet suivant et simuler un clic
		e.preventDefault(); // Empêcher le comportement par défaut
	} else if (e.key === 'ArrowLeft') { // Flèche gauche
		index = (index - 1 + $tabs.length) % $tabs.length; // Passer à l'onglet précédent
		$tabs.eq(index).focus().click(); // Mettre le focus sur l'onglet précédent et simuler un clic
		e.preventDefault(); // Empêcher le comportement par défaut
	}
});

	// Initialiser l'affichage du contenu du premier onglet
	$('.et_pb_tab_content').first().show(); // Afficher le contenu du premier onglet par defaut
});

// Ajouter un attribut title aux liens module Tabs
jQuery(document).ready(function($) {
$('.et_pb_tabs .et_pb_tab_content a').each(function() {
		var $this = $(this);
		var linkText = $this.text().trim();
		var href = $this.attr('href');
		var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
		var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

		if (isDocument) {
			// Mettre à jour le title pour les documents avec le format
			$this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
		} else if ($this.find('svg').length > 0) {
			$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
		} else {
			$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
		}
	});
});

//******************/
// ** Module Blurb */
//******************/

// Ajouter un attribut title aux liens module Blurb
jQuery(document).ready(function($) {
    $('.et_pb_blurb_description a').each(function() {
			var $this = $(this);
			var linkText = $this.text().trim();
			var href = $this.attr('href');
			var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
			var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

			if (isDocument) {
				// Mettre à jour le title pour les documents avec le format
				$this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
			} else if ($this.find('svg').length > 0) {
				$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
			} else {
				$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
			}
		});
	});

// Ajouter un attribut title au lien sur et_pb_module_header (titre du module Blurb)
jQuery(document).ready(function($) {
    $('.et_pb_blurb_content .et_pb_module_header a').each(function() {
			var $this = $(this);
			var linkText = $this.text().trim();
			var href = $this.attr('href');
			var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
			var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

			if (isDocument) {
				// Mettre à jour le title pour les documents avec le format
				$this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
			} else if ($this.find('svg').length > 0) {
				$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
			} else {
				$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
			}
		});
	});


//*******************/
// ** Module Button */
//*******************/
	
// Ajouter un attribut title aux liens du module Button	
jQuery(document).ready(function($) {
    $('.et_pb_button').each(function() {
        var $this = $(this);
        var linkText = $this.text().trim();
        var href = $this.attr('href');
        var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
        var isTargetBlank = $this.attr('target') === '_blank';

        if (isDocument) {
            // Mettre à jour le title pour les documents avec le format
            $this.attr('title', "Télécharger " + linkText + " au format " + href.split('.').pop().toUpperCase() + " dans une nouvelle fenêtre");
        } else if (isTargetBlank) {
            // Pas de SVG, mais target _blank
            $this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
        } else {
            $this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
        }
    });
});


/*************************/
/* Module Call to action */
/*************************/

// Ajouter un attribut title aux liens module Call to action
jQuery(document).ready(function($) {
    $('.et_pb_promo_description div a').each(function() {
        var $this = $(this);
        var linkText = $this.text().trim();
        var href = $this.attr('href');
        var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
        var isTargetBlank = $this.attr('target') === '_blank';

        if (isDocument) {
            // Mettre à jour le title pour les documents avec le format
            $this.attr('title', "Télécharger " + linkText + " au format " + href.split('.').pop().toUpperCase() + " dans une nouvelle fenêtre");
        } else if (isTargetBlank) {
            // Pas de SVG, mais target _blank
            $this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
        } else {
            $this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
        }
    });
});


/***************/
/* Module Blog */
/***************/

// Ajouter un attribut liens h2 module Blog
jQuery(document).ready(function($) {
    $('.entry-title a').each(function() {
        var $this = $(this);
        var linkText = $this.text().trim();
        var href = $this.attr('href');

        // Correction de la condition if
        if ($this.attr('target') === '_blank') {
            $this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
        } else {
            $this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
        }
    });
});


// Ajouter un attribut title aux liens module Blog
jQuery(document).ready(function($) {
    $('.post-meta a').each(function() {
        var $this = $(this);
        var linkText = $this.text().trim();
        var href = $this.attr('href');

        // Correction de la condition if
        if ($this.attr('target') === '_blank') {
            $this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
        } else {
            $this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
        }
    });
});

/**********************/
/* Module Post slider */
/**********************/

// Ajouter un attribut title aux liens module Post slider
jQuery(document).ready(function($) {
    $('.et_pb_post_slider .post-meta a').each(function() {
        var $this = $(this);
        var linkText = $this.text().trim();
        var href = $this.attr('href');

        // Correction de la condition if
        if ($this.attr('target') === '_blank') {
            $this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
        } else {
            $this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
        }
    });
});

// Bouton Pause du Slider
jQuery(document).ready(function($) {
    const toggleButton = $('#carouselPlayButton');
    const slider = $('.et_pb_slider');

    let isPaused = false;

    // Appliquer la classe au survol
    toggleButton.on('mouseenter', function() {
        slider.addClass('et_slider_hovered');
    });

    // Retirer la classe lorsque la souris quitte le bouton
    toggleButton.on('mouseleave', function() {
        if (!isPaused) {
            slider.removeClass('et_slider_hovered');
        }
    });

    toggleButton.on('click', function() {
        isPaused = !isPaused;

        if (isPaused) {
            console.log('Slider paused, class added: et_slider_hovered');
        } else {
            slider.addClass('et_slider_auto'); 
            console.log('Slider playing, class removed: et_slider_hovered');
        }

        console.log('Toggle button clicked');
    });
});

/*****************/
/* Module Person */
/*****************/

// Ajouter un attribut title aux liens module Person
jQuery(document).ready(function($) {
    $('.et_pb_team_member_description a').each(function() {
			var $this = $(this);
			var linkText = $this.text().trim();
			var href = $this.attr('href');
			var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
			var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

			if (isDocument) {
				// Mettre à jour le title pour les documents avec le format
				$this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
			} else if ($this.find('svg').length > 0) {
				$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
			} else {
				$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
			}
		});
	});

/**********************/
/* Module Testimonial */
/**********************/

// Ajouter un attribut title aux liens module Testimonial
jQuery(document).ready(function($) {
    $('.et_pb_testimonial_description a').each(function() {
			var $this = $(this);
			var linkText = $this.text().trim();
			var href = $this.attr('href');
			var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
			var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

			if (isDocument) {
				// Mettre à jour le title pour les documents avec le format
				$this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
			} else if ($this.find('svg').length > 0) {
				$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
			} else {
				$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
			}
		});
	});

/**********************/
/* Module Post title */
/**********************/

// Ajouter un attribut title aux liens module Post title
jQuery(document).ready(function($) {
    $('.et_pb_title_meta_container a').each(function() {
        var $this = $(this);
        var linkText = $this.text().trim();
        var href = $this.attr('href');

		if ($this.find('svg').length > 0) {
					$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
				} else {
					$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
				}
			});
		});

/**********************/
/* Module Email Optin */
/**********************/

// Ajouter un attribut title aux liens module Post title
jQuery(document).ready(function($) {
    $('.et_pb_newsletter_description a').each(function() {
			var $this = $(this);
			var linkText = $this.text().trim();
			var href = $this.attr('href');
			var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
			var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

			if (isDocument) {
				// Mettre à jour le title pour les documents avec le format
				$this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
			} else if ($this.find('svg').length > 0) {
				$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
			} else {
				$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
			}
		});
	});

/****************/
/* Module Login */
/****************/

// Ajouter un attribut title aux liens module Post title
jQuery(document).ready(function($) {
    $('.et_pb_login a').each(function() {
			var $this = $(this);
			var linkText = $this.text().trim();
			var href = $this.attr('href');
			var isDocument = /\.(pdf|docx?|pptx?|xlsx?)$/i.test(href);
			var fileExtension = href.split('.').pop(); // Récupérer l'extension du fichier

			if (isDocument) {
				// Mettre à jour le title pour les documents avec le format
				$this.attr('title', "Télécharger " + linkText + " au format " + fileExtension.toUpperCase() + " dans une nouvelle fenêtre ");
			} else if ($this.find('svg').length > 0) {
				$this.attr('title', "Ouvrir " + linkText + " dans une nouvelle fenêtre");
			} else {
				$this.attr('title', "Ouvrir " + linkText + " dans le même onglet");
			}
		});
	});
	

//*********************************************/
//** Code ARIA pour le Plugin Contact Form 7  */
//*********************************************/

jQuery(document).ready(function($) {
	// Ecouter l'evenement de soumission du formulaire
	$(document).on('wpcf7invalid', function(event) {
		// Afficher le message d'erreur si le champ est invalide
		$('#error-name').attr('aria-hidden', 'false').show();
		$('#name').attr('aria-invalid', 'true'); // Marquer le champ comme invalide
	});

	$(document).on('wpcf7valid', function(event) {
		// Masquer le message d'erreur si le champ est valide
		$('#error-name').attr('aria-hidden', 'true').hide();
		$('#name').attr('aria-invalid', 'false'); // Marquer le champ comme valide
	});
});
	
//*******************************************************************/
//** Afficher dans un ordre linéaire les tableaux html de WordPress */
//*******************************************************************/
	
jQuery(document).ready(function($) {
    // Injecter le CSS pour la classe 'visually-hidden' et 'linear-table'
    if (!$('style#visually-hidden-style').length) {
        $('head').append('<style id="visually-hidden-style">\
            .visually-hidden {\
                position: absolute !important;\
                width: 1px !important;\
                height: 1px !important;\
                padding: 0 !important;\
                margin: -1px !important;\
                overflow: hidden !important;\
                clip: rect(0, 0, 0, 0);\
                white-space: nowrap !important;\
                border: 0 !important;\
            }\
            .linear-table {\
                display: none; /* Cacher visuellement la version linéaire */\
            }\
        </style>');
    }

    // Sélectionner le tableau
    var $table = $('table');

    // Vérifier si le tableau a déjà une légende, sinon en ajouter une
    if ($table.find('caption').length === 0) {
        $table.prepend('<caption class="visually-hidden">Tableau des catégories et leurs descriptions</caption>');
    } else {
        // Si la légende existe, lui ajouter la classe pour la cacher visuellement
        $table.find('caption').addClass('visually-hidden');
    }

    // Créer un en-tête pour la version linéaire
    var $header = $('<h2 class="visually-hidden">Vue linéaire des informations</h2>');

    // Créer un nouveau conteneur pour la version linéaire
    var $linearContainer = $('<div class="linear-table"></div>');

    // Parcourir chaque ligne du tableau
    $table.find('tbody tr').each(function() {
        var $row = $(this);
        var $cells = $row.find('td');

        // Extraire le contenu de chaque cellule
        var title = $cells.eq(0).html();
        var description = $cells.eq(1).html();
        var listItems = $cells.eq(2).find('li');

        // Créer une nouvelle structure pour chaque ligne
        var $section = $('<div class="linear-section"></div>');

        // Ajouter le titre
        $section.append('<h3>' + $(title).text() + '</h3>');

        // Ajouter la description
        $section.append('<p>' + $(description).text() + '</p>');

        // Ajouter la liste
        if (listItems.length > 0) {
            var $ul = $('<ul></ul>');
            listItems.each(function() {
                $ul.append('<li>' + $(this).text() + '</li>');
            });
            $section.append($ul);
        }

        // Ajouter la section au conteneur principal
        $linearContainer.append($section);
    });

    // Insérer l'en-tête et la nouvelle version après le tableau original
    $table.after($header).after($linearContainer);

    // Optionnel : cacher le tableau original
    // Décommentez la ligne suivante si vous souhaitez cacher le tableau original
    // $table.hide();
});


//**************************************/
//** Module Circle counter, rôles ARIA */
//**************************************/

jQuery(document).ready(function($) {
    var $counter = $('.et_pb_circle_counter_inner');
    if ($counter.length) {
        var value = $counter.data('number-value');
        $counter.attr('aria-valuenow', value);
        $counter.attr('aria-valuetext', value + '%');
    } else {
        console.log('Élément non trouvé');
    }
});

//***********************************/
//** Module Bar counter, rôles ARIA */
//***********************************/

jQuery(document).ready(function($) {
    // Vérifier si la zone ARIA existe déjà
    var $status = $('#counter-aria');
    if (!$status.length) {
        // Créer la zone ARIA invisible
        $status = $('<div id="counter-aria" role="status" aria-live="polite"></div>');
        // Appliquer le style pour la cacher visuellement mais accessible
        $status.css({
            position: 'absolute',
            left: '-9999px',
            width: '1px',
            height: '1px',
            overflow: 'hidden'
        });
        // Ajouter la zone dans le body
        $('body').append($status);
    }

    // Sélectionner le contenu du compteur qui change dynamiquement
    var $counterInner = $('.et_pb_counter_amount_number_inner');

    if ($counterInner.length) {
        // Observer pour détecter les changements dans le texte
        var observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                if (mutation.type === 'childList') {
                    var newValue = $(mutation.target).text();
                    // Mettre à jour la zone ARIA pour l'annonce
                    $status.text('Valeur du compteur : ' + newValue);
                }
            });
        });

        // Surveille les changements dans le texte du compteur
        observer.observe($counterInner[0], { childList: true, subtree: true });
    }
});

/******************/
/* Module Gallery */
/******************/

jQuery(document).ready(function($) {
    function améliorerAccessibilité() {
        // Pour le lien "Précédent"
        var prevLi = $('li.prev');
        var prevLink = prevLi.find('a.page-prev');
        if (prevLink.length) {
            // Vérifier et mettre à jour le texte
            if (prevLink.text().trim() !== 'Précédent') {
                prevLink.text('Précédent');
            }
            // Mettre à jour ou ajouter aria-label
            prevLink.attr('aria-label', 'Précédent');
            // Si le li est masqué, le rendre visible pour l'accessibilité
            if (prevLi.css('display') === 'none') {
                prevLi.css('display', 'list-item');
            }
        }

        // Pour le lien "Suivant"
        var nextLi = $('li.next');
        var nextLink = nextLi.find('a.page-next');
        if (nextLink.length) {
            if (nextLink.text().trim() !== 'Suivant') {
                nextLink.text('Suivant');
            }
            nextLink.attr('aria-label', 'Suivant');
            if (nextLi.css('display') === 'none') {
                nextLi.css('display', 'list-item');
            }
        }
    }

    // Exécuter une fois au chargement
    améliorerAccessibilité();

    // Si la pagination est modifiée dynamiquement, réexécuter périodiquement
    var intervalId = setInterval(function() {
        améliorerAccessibilité();

        // Arrêter si tout est correct
        if ($('li.prev').find('a.page-prev').text().trim() === 'Précédent' &&
            $('li.next').find('a.page-next').text().trim() === 'Suivant') {
            clearInterval(intervalId);
        }
    }, 500);
});

	
jQuery(document).ready(function($) {
    // Ajout d'attributs ARIA aux images de la galerie
    $('.et_pb_gallery_image').each(function() {
        var altText = $(this).attr('alt');
        $(this).attr('aria-label', altText);
    });
});

	
/**************** Plugins du projet ***************/	

//*************************************/
//** Liens pour le Plugin TablePress  */
//*************************************/












